-- =============================================
-- HAPPY AT LAW - COMPLETE QUIZ SEED DATA
-- Two Quizzes: Foundation Score + Copycat Risk
-- =============================================

-- Clear existing data (careful in production!)
SET FOREIGN_KEY_CHECKS = 0;
TRUNCATE TABLE quiz_sessions;
TRUNCATE TABLE leads;
TRUNCATE TABLE question_options;
TRUNCATE TABLE questions;
TRUNCATE TABLE results;
TRUNCATE TABLE pages;
TRUNCATE TABLE quizzes;
SET FOREIGN_KEY_CHECKS = 1;

-- =============================================
-- QUIZ 1: BUSINESS FOUNDATION SCORE
-- Domain: myfoundationscore.com
-- =============================================

INSERT INTO quizzes (id, uuid, title, slug, description, custom_domain, is_default, published, settings) VALUES (
  1,
  UUID(),
  'Business Foundation Score',
  'foundation-score',
  'Discover how protected your business really is with this 2-minute assessment.',
  'myfoundationscore.com',
  1,
  1,
  JSON_OBJECT(
    'scoring_type', 'points',
    'show_progress', true,
    'require_email', true,
    'email_position', 'before_results',
    'primary_color', '#000058',
    'secondary_color', '#f06e73',
    'font', 'Open Sans',
    'ga4_measurement_id', '',
    'meta_pixel_id', ''
  )
);

-- QUIZ 1: LANDING PAGE
INSERT INTO pages (id, quiz_id, type, slug, title, blocks, settings) VALUES (
  1, 1, 'landing', 'landing', 'Business Foundation Score',
  JSON_ARRAY(
    JSON_OBJECT(
      'type', 'hero',
      'headline', 'What''s Your Business Foundation Score?',
      'subheadline', 'Most entrepreneurs are missing critical protections they don''t even know about. This 2-minute quiz reveals exactly where you''re vulnerable.',
      'image', ''
    ),
    JSON_OBJECT(
      'type', 'benefits',
      'title', 'In the next 2 minutes, discover:',
      'items', JSON_ARRAY(
        'Which of the 7 critical protection areas you''re missing',
        'Your personalized Foundation Score (out of 100)',
        'Exactly where to focus first to protect your business',
        'A custom action plan based on YOUR gaps'
      )
    ),
    JSON_OBJECT(
      'type', 'social_proof',
      'text', 'Join 1,000+ entrepreneurs who''ve strengthened their business foundation'
    ),
    JSON_OBJECT(
      'type', 'cta',
      'button_text', 'Get My Foundation Score →',
      'subtext', 'Free • 2 Minutes • Instant Results'
    )
  ),
  JSON_OBJECT('show_logo', true, 'background_color', '#ffffff')
);

-- QUIZ 1: OPT-IN PAGE (before results)
INSERT INTO pages (id, quiz_id, type, slug, title, blocks, settings) VALUES (
  2, 1, 'optin', 'optin', 'Get Your Results',
  JSON_ARRAY(
    JSON_OBJECT(
      'type', 'headline',
      'text', 'Your Foundation Score is Ready!'
    ),
    JSON_OBJECT(
      'type', 'subheadline', 
      'text', 'Enter your email to see your personalized score, risk areas, and custom action plan.'
    ),
    JSON_OBJECT(
      'type', 'form',
      'fields', JSON_ARRAY('email', 'first_name'),
      'button_text', 'See My Results →',
      'privacy_text', 'We respect your privacy. Unsubscribe anytime.'
    )
  ),
  JSON_OBJECT()
);

-- QUIZ 1: QUESTIONS (10 questions covering 7 areas)

-- Q1: Client Relationships (Day 1 topic)
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  1, 1, UUID(),
  'How do you currently handle new client onboarding?',
  'single_choice',
  'Think about your process from first contact to starting work.',
  1, 1
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(1, UUID(), 'Contracts signed BEFORE any work begins, with clear expectations documented', 1, 10),
(1, UUID(), 'I have contracts but sometimes start work before they''re signed', 2, 6),
(1, UUID(), 'I use basic agreements but they''re pretty informal', 3, 3),
(1, UUID(), 'I mostly work on verbal agreements or handshakes', 4, 0);

-- Q2: Scope Creep Protection (Day 2 topic)
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  2, 1, UUID(),
  'When a client asks for "just one more thing" outside the original scope, what happens?',
  'single_choice',
  'Be honest about your typical response.',
  1, 2
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(2, UUID(), 'I have a clear change order process with additional fees', 1, 10),
(2, UUID(), 'I usually discuss it and sometimes charge extra', 2, 6),
(2, UUID(), 'I often do it to keep the client happy, even if unpaid', 3, 3),
(2, UUID(), 'I don''t really track scope - I just do what''s needed', 4, 0);

-- Q3: Business Boundaries
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  3, 1, UUID(),
  'How clearly defined are your service boundaries and deliverables?',
  'single_choice',
  'Think about your service descriptions and what clients expect.',
  1, 3
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(3, UUID(), 'Crystal clear - specific deliverables, timelines, and what''s NOT included', 1, 10),
(3, UUID(), 'Mostly clear but some gray areas exist', 2, 6),
(3, UUID(), 'Somewhat vague - clients sometimes expect more than I intended', 3, 3),
(3, UUID(), 'Very flexible - I figure it out as we go', 4, 0);

-- Q4: Force Majeure / Emergency Protection (Day 3 topic)
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  4, 1, UUID(),
  'If you got sick or had an emergency and couldn''t deliver for 2 weeks, what would happen?',
  'single_choice',
  'Consider your current contracts and client expectations.',
  1, 4
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(4, UUID(), 'My contracts have force majeure clauses - clients know the plan', 1, 10),
(4, UUID(), 'I''d communicate with clients but I''m not sure of my legal obligations', 2, 5),
(4, UUID(), 'I''d probably have to offer refunds or rush to make it up', 3, 2),
(4, UUID(), 'Honestly? It would be chaos and I might lose clients', 4, 0);

-- Q5: AI & Data Protection (Day 4 topic)
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  5, 1, UUID(),
  'How do you handle AI tools and client data privacy?',
  'single_choice',
  'Think about tools like ChatGPT, Zoom transcription, etc.',
  1, 5
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(5, UUID(), 'Clear AI policy in contracts + never put sensitive client data in AI tools', 1, 10),
(5, UUID(), 'I''m careful with data but haven''t formalized policies', 2, 5),
(5, UUID(), 'I use AI tools but haven''t thought much about client data implications', 3, 2),
(5, UUID(), 'I''m not sure what data goes where honestly', 4, 0);

-- Q6: Intellectual Property Protection (Day 5 topic)
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  6, 1, UUID(),
  'How well is your unique methodology, content, or "secret sauce" protected?',
  'single_choice',
  'Think about your frameworks, processes, courses, templates.',
  1, 6
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(6, UUID(), 'Strong IP clauses in all contracts + registered trademarks/copyrights where needed', 1, 10),
(6, UUID(), 'Some protection in contracts but nothing formally registered', 2, 5),
(6, UUID(), 'Basic terms of service but not confident it''s enough', 3, 2),
(6, UUID(), 'Anyone could copy my stuff and I couldn''t do much about it', 4, 0);

-- Q7: Personal/Business Separation (Day 6 topic)
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  7, 1, UUID(),
  'How separated are your personal and business assets?',
  'single_choice',
  'Consider your business structure, addresses, and liability.',
  1, 7
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(7, UUID(), 'LLC/Corp properly maintained + registered agent + separate everything', 1, 10),
(7, UUID(), 'I have an LLC but use my home address and mix some things', 2, 5),
(7, UUID(), 'Sole proprietor with some informal separation', 3, 2),
(7, UUID(), 'Everything is mixed together under my personal name', 4, 0);

-- Q8: Confidentiality (Day 7 topic)
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  8, 1, UUID(),
  'How do you protect confidential client information?',
  'single_choice',
  'Think about NDAs, group programs, and sensitive data.',
  1, 8
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(8, UUID(), 'Strong confidentiality clauses + clear group guidelines + secure data handling', 1, 10),
(8, UUID(), 'Basic confidentiality mentioned but not detailed', 2, 5),
(8, UUID(), 'I keep things private but nothing formal in writing', 3, 2),
(8, UUID(), 'Haven''t really thought about formalizing confidentiality', 4, 0);

-- Q9: Refund & Termination Policies
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  9, 1, UUID(),
  'What happens if a client wants a refund or to cancel mid-project?',
  'single_choice',
  'Consider your current policies and past experiences.',
  1, 9
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(9, UUID(), 'Clear refund policy in contracts with specific terms and timelines', 1, 10),
(9, UUID(), 'I have a policy but it''s somewhat flexible case-by-case', 2, 6),
(9, UUID(), 'I usually just give refunds to avoid conflict', 3, 3),
(9, UUID(), 'No policy - I deal with it when it comes up', 4, 0);

-- Q10: Overall Confidence
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  10, 1, UUID(),
  'Overall, how confident do you feel about your business protection?',
  'single_choice',
  'Trust your gut on this one.',
  1, 10
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(10, UUID(), 'Very confident - I sleep well knowing I''m protected', 1, 10),
(10, UUID(), 'Somewhat confident but I know there are gaps', 2, 6),
(10, UUID(), 'Not very confident - I worry about what could go wrong', 3, 3),
(10, UUID(), 'I basically hope for the best and deal with problems as they come', 4, 0);

-- QUIZ 1: RESULTS (3 tiers based on score)
-- Max score: 100 points (10 questions × 10 points)

-- Result 1: Strong Foundation (80-100)
INSERT INTO results (id, quiz_id, uuid, title, slug, min_score, max_score, description, cta_text, cta_url, cta_button_text) VALUES (
  1, 1, UUID(),
  'Strong Foundation',
  'strong-foundation',
  80, 100,
  '<h2>🎉 Congratulations! You Have a Strong Foundation</h2>
<p><strong>Your Score: {{score}} out of 100</strong></p>

<p>You''re in the top 15% of entrepreneurs when it comes to business protection. You have solid contracts, clear boundaries, and professional systems in place.</p>

<h3>Your Strengths:</h3>
<ul>
<li>✅ Professional client onboarding</li>
<li>✅ Clear scope and boundaries</li>
<li>✅ Strong legal documentation</li>
</ul>

<h3>Even Strong Foundations Can Improve</h3>
<p>While your foundation is solid, the business landscape keeps changing. New threats like AI compliance, evolving privacy laws, and sophisticated IP theft mean even protected businesses need to stay current.</p>

<p><strong>The 7-Day Contract Assessment Challenge</strong> will help you:</p>
<ul>
<li>🔍 Identify any remaining blind spots</li>
<li>📋 Get updated templates for 2024 compliance</li>
<li>🛡️ Add layers of protection you might not know exist</li>
</ul>',
  'Stay ahead of the curve with a professional tune-up:',
  'https://happyatlawnetwork.com/plans/1952315?bundle_token=797d0596dd239eeb6addca4b43dd3c7c&utm_source=quiz&utm_campaign=foundation_score&utm_content=strong',
  'Join the $97 Challenge →'
);

-- Result 2: Growing Foundation (50-79)
INSERT INTO results (id, quiz_id, uuid, title, slug, min_score, max_score, description, cta_text, cta_url, cta_button_text) VALUES (
  2, 1, UUID(),
  'Growing Foundation',
  'growing-foundation',
  50, 79,
  '<h2>📈 You Have a Growing Foundation</h2>
<p><strong>Your Score: {{score}} out of 100</strong></p>

<p>You''ve made good progress protecting your business, but there are gaps that could cost you thousands if the wrong situation hits.</p>

<h3>What''s Working:</h3>
<ul>
<li>✅ You have some contracts in place</li>
<li>✅ You understand the importance of protection</li>
<li>✅ You''re taking steps in the right direction</li>
</ul>

<h3>Where You''re Exposed:</h3>
<ul>
<li>⚠️ Scope creep may be draining $1,000+ monthly</li>
<li>⚠️ Gaps in your contracts leave room for disputes</li>
<li>⚠️ One difficult client could create major problems</li>
</ul>

<h3>The Good News</h3>
<p>Your foundation is fixable—and faster than you think. The <strong>7-Day Contract Assessment Challenge</strong> is designed exactly for entrepreneurs at your stage.</p>

<p>In just 60-90 minutes per day, you''ll:</p>
<ul>
<li>🔍 Identify your specific vulnerability gaps</li>
<li>📋 Get templates to fix each issue</li>
<li>🛡️ Build protection that prevents problems before they start</li>
</ul>',
  'Fix your gaps before they cost you:',
  'https://happyatlawnetwork.com/plans/1952315?bundle_token=797d0596dd239eeb6addca4b43dd3c7c&utm_source=quiz&utm_campaign=foundation_score&utm_content=growing',
  'Start the $97 Challenge →'
);

-- Result 3: Building Foundation (0-49)
INSERT INTO results (id, quiz_id, uuid, title, slug, min_score, max_score, description, cta_text, cta_url, cta_button_text) VALUES (
  3, 1, UUID(),
  'Building Foundation',
  'building-foundation',
  0, 49,
  '<h2>🚧 Your Foundation Needs Attention</h2>
<p><strong>Your Score: {{score}} out of 100</strong></p>

<p>Let''s be honest: your business is more exposed than it should be. But here''s the thing—<strong>you''re not alone</strong>. Most entrepreneurs start exactly where you are.</p>

<h3>Current Risk Areas:</h3>
<ul>
<li>🚨 Scope creep could be costing you $3,000+/month</li>
<li>🚨 One difficult client could demand a $5,000+ refund</li>
<li>🚨 Your IP and "secret sauce" may not be protected</li>
<li>🚨 A single emergency could derail your business</li>
</ul>

<h3>This Is Actually Good News</h3>
<p>Why? Because now you <em>know</em>. Most entrepreneurs don''t discover these gaps until something goes wrong. You have the chance to fix this <em>before</em> it costs you.</p>

<h3>The Fastest Path Forward</h3>
<p>The <strong>7-Day Contract Assessment Challenge</strong> was built for exactly this situation. In one week, you''ll go from exposed to protected:</p>

<ul>
<li>📅 <strong>Day 1:</strong> Stop cranky clients before they start</li>
<li>📅 <strong>Day 2:</strong> Eliminate scope creep for good</li>
<li>📅 <strong>Day 3:</strong> Protect against emergencies</li>
<li>📅 <strong>Day 4:</strong> Handle AI and data properly</li>
<li>📅 <strong>Day 5:</strong> Protect your intellectual property</li>
<li>📅 <strong>Day 6:</strong> Separate personal and business</li>
<li>📅 <strong>Day 7:</strong> Lock down confidentiality</li>
</ul>

<p><strong>Just 60-90 minutes per day. $97 total. Could save you $25,000+ in avoided disasters.</strong></p>',
  'Start building your protection today:',
  'https://happyatlawnetwork.com/plans/1952315?bundle_token=797d0596dd239eeb6addca4b43dd3c7c&utm_source=quiz&utm_campaign=foundation_score&utm_content=building',
  'Join the $97 Challenge →'
);


-- =============================================
-- QUIZ 2: COPYCAT RISK FACTOR
-- Domain: copycatriskfactor.com
-- =============================================

INSERT INTO quizzes (id, uuid, title, slug, description, custom_domain, is_default, published, settings) VALUES (
  2,
  UUID(),
  'Copycat Risk Factor',
  'copycat-risk',
  'Find out if your ideas, frameworks, and content are actually protected—or if anyone could legally steal them tomorrow.',
  'copycatriskfactor.com',
  0,
  1,
  JSON_OBJECT(
    'scoring_type', 'points',
    'show_progress', true,
    'require_email', true,
    'email_position', 'before_results',
    'primary_color', '#000058',
    'secondary_color', '#f06e73',
    'font', 'Open Sans',
    'ga4_measurement_id', '',
    'meta_pixel_id', ''
  )
);

-- QUIZ 2: LANDING PAGE
INSERT INTO pages (id, quiz_id, type, slug, title, blocks, settings) VALUES (
  3, 2, 'landing', 'landing', 'Copycat Risk Factor',
  JSON_ARRAY(
    JSON_OBJECT(
      'type', 'hero',
      'headline', 'Could Someone Legally Steal Your Entire Business Tomorrow?',
      'subheadline', 'Your frameworks, courses, methods, and "secret sauce" might not be as protected as you think. Find out in 2 minutes.',
      'image', ''
    ),
    JSON_OBJECT(
      'type', 'pain_points',
      'title', 'This quiz is for you if:',
      'items', JSON_ARRAY(
        'You''ve created a unique framework, method, or process',
        'You sell courses, coaching, or digital products',
        'You''ve seen competitors with suspiciously similar offers',
        'You''re not 100% sure your content is legally protected'
      )
    ),
    JSON_OBJECT(
      'type', 'stats',
      'text', '73% of online entrepreneurs have ZERO legal protection for their intellectual property'
    ),
    JSON_OBJECT(
      'type', 'cta',
      'button_text', 'Check My Copycat Risk →',
      'subtext', 'Free • 2 Minutes • Instant Risk Assessment'
    )
  ),
  JSON_OBJECT('show_logo', true, 'background_color', '#ffffff')
);

-- QUIZ 2: OPT-IN PAGE
INSERT INTO pages (id, quiz_id, type, slug, title, blocks, settings) VALUES (
  4, 2, 'optin', 'optin', 'Get Your Risk Assessment',
  JSON_ARRAY(
    JSON_OBJECT(
      'type', 'headline',
      'text', 'Your Copycat Risk Assessment is Ready!'
    ),
    JSON_OBJECT(
      'type', 'subheadline', 
      'text', 'Enter your email to see your risk level and get your personalized IP protection plan.'
    ),
    JSON_OBJECT(
      'type', 'form',
      'fields', JSON_ARRAY('email', 'first_name'),
      'button_text', 'See My Risk Level →',
      'privacy_text', 'We respect your privacy. Unsubscribe anytime.'
    )
  ),
  JSON_OBJECT()
);

-- QUIZ 2: QUESTIONS (8 questions focused on IP)

-- Q1: What You've Created
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  11, 2, UUID(),
  'What type of original content or methodology have you created?',
  'multiple_choice',
  'Select all that apply.',
  1, 1
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(11, UUID(), 'A signature framework or methodology', 1, 3),
(11, UUID(), 'Online courses or training programs', 2, 3),
(11, UUID(), 'Templates, worksheets, or tools', 3, 2),
(11, UUID(), 'Written content (blogs, books, guides)', 4, 2),
(11, UUID(), 'Unique processes or systems', 5, 3),
(11, UUID(), 'Brand name or tagline I''m known for', 6, 2);

-- Q2: Current Protection Level
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  12, 2, UUID(),
  'What legal protection do you currently have for your intellectual property?',
  'single_choice',
  'Be honest about your current situation.',
  1, 2
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(12, UUID(), 'Registered trademarks AND copyrights for key assets', 1, 10),
(12, UUID(), 'Some registrations but not comprehensive', 2, 6),
(12, UUID(), 'Only terms of service on my website', 3, 3),
(12, UUID(), 'Nothing formal - just hoping no one copies me', 4, 0);

-- Q3: Contract Protection
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  13, 2, UUID(),
  'Do your client/customer contracts include IP protection clauses?',
  'single_choice',
  'Think about your service agreements, course terms, etc.',
  1, 3
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(13, UUID(), 'Yes - clear clauses about ownership, usage rights, and restrictions', 1, 10),
(13, UUID(), 'Some IP language but not very detailed', 2, 5),
(13, UUID(), 'Basic terms but nothing specific about IP', 3, 2),
(13, UUID(), 'No - clients could probably use my stuff however they want', 4, 0);

-- Q4: Team/Contractor Protection
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  14, 2, UUID(),
  'When you hire contractors, VAs, or team members, who owns what they create?',
  'single_choice',
  'Consider content, designs, courses, or systems they help build.',
  1, 4
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(14, UUID(), 'Clear work-for-hire agreements - I own everything they create', 1, 10),
(14, UUID(), 'I have contracts but IP ownership isn''t clearly stated', 2, 5),
(14, UUID(), 'Verbal agreements only', 3, 2),
(14, UUID(), 'I''ve never thought about who owns what they create', 4, 0);

-- Q5: Course/Program Protection
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  15, 2, UUID(),
  'If you sell courses or programs, what stops students from copying and reselling your content?',
  'single_choice',
  'Think about your terms of purchase.',
  1, 5
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(15, UUID(), 'Clear terms prohibiting redistribution with legal consequences', 1, 10),
(15, UUID(), 'Terms of service that mention it but aren''t very detailed', 2, 5),
(15, UUID(), 'I ask people not to share but nothing legal', 3, 2),
(15, UUID(), 'Nothing - someone could copy and sell my course tomorrow', 4, 0);

-- Q6: Competitor Awareness
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  16, 2, UUID(),
  'Have you ever seen a competitor with content suspiciously similar to yours?',
  'single_choice',
  'Be honest.',
  1, 6
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(16, UUID(), 'Yes, and I had legal recourse to address it', 1, 10),
(16, UUID(), 'Yes, but I couldn''t do anything about it', 2, 0),
(16, UUID(), 'Not yet, but I worry about it', 3, 3),
(16, UUID(), 'I''ve never really checked', 4, 2);

-- Q7: Website Protection
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  17, 2, UUID(),
  'What protection do you have on your website for your free content?',
  'single_choice',
  'Think about blog posts, lead magnets, videos, etc.',
  1, 7
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(17, UUID(), 'Terms of service prohibiting commercial use + copyright notices', 1, 10),
(17, UUID(), 'Basic copyright notice in footer', 2, 5),
(17, UUID(), 'Terms of service but nothing about content usage', 3, 2),
(17, UUID(), 'No terms of service at all', 4, 0);

-- Q8: Overall IP Confidence
INSERT INTO questions (id, quiz_id, uuid, question_text, question_type, description, required, order_index) VALUES (
  18, 2, UUID(),
  'If someone copied your core framework tomorrow, what could you legally do?',
  'single_choice',
  'Trust your gut.',
  1, 8
);

INSERT INTO question_options (question_id, uuid, option_text, order_index, points) VALUES
(18, UUID(), 'Send a cease and desist with real legal backing', 1, 10),
(18, UUID(), 'Probably something but I''m not sure what', 2, 4),
(18, UUID(), 'Complain on social media?', 3, 1),
(18, UUID(), 'Honestly... probably nothing', 4, 0);

-- QUIZ 2: RESULTS
-- Max score: 80 points (8 questions)

-- Result 1: Low Risk (60-80)
INSERT INTO results (id, quiz_id, uuid, title, slug, min_score, max_score, description, cta_text, cta_url, cta_button_text) VALUES (
  4, 2, UUID(),
  'Low Copycat Risk',
  'low-risk',
  60, 80,
  '<h2>🛡️ Low Copycat Risk - Well Protected!</h2>
<p><strong>Your Risk Level: LOW</strong></p>

<p>Great news! You''ve done more than most entrepreneurs to protect your intellectual property. Your frameworks, content, and methods have real legal protection.</p>

<h3>Your Protection Strengths:</h3>
<ul>
<li>✅ Legal registrations in place</li>
<li>✅ Contracts that protect your IP</li>
<li>✅ Clear ownership of created content</li>
</ul>

<h3>Stay Protected as You Grow</h3>
<p>IP protection isn''t "set and forget." As you create new content, hire new contractors, and expand your offerings, new vulnerabilities can appear.</p>

<p>The <strong>7-Day Contract Assessment Challenge</strong> (Day 5 specifically covers advanced IP protection) will help you:</p>
<ul>
<li>🔍 Identify any new exposure points</li>
<li>📋 Get updated IP protection templates</li>
<li>🛡️ Stay ahead of sophisticated copycats</li>
</ul>',
  'Keep your protection current:',
  'https://happyatlawnetwork.com/plans/1952315?bundle_token=797d0596dd239eeb6addca4b43dd3c7c&utm_source=quiz&utm_campaign=copycat_risk&utm_content=low',
  'Join the $97 Challenge →'
);

-- Result 2: Medium Risk (30-59)
INSERT INTO results (id, quiz_id, uuid, title, slug, min_score, max_score, description, cta_text, cta_url, cta_button_text) VALUES (
  5, 2, UUID(),
  'Medium Copycat Risk',
  'medium-risk',
  30, 59,
  '<h2>⚠️ Medium Copycat Risk - Gaps Exist</h2>
<p><strong>Your Risk Level: MEDIUM</strong></p>

<p>You have some protection in place, but there are gaps that leave your intellectual property vulnerable. A savvy competitor could exploit these weaknesses.</p>

<h3>Where You''re Protected:</h3>
<ul>
<li>✅ Some legal foundations exist</li>
<li>✅ You understand the importance of IP</li>
</ul>

<h3>Where You''re Exposed:</h3>
<ul>
<li>⚠️ Contracts may not fully protect your methods</li>
<li>⚠️ Contractors could claim ownership of content</li>
<li>⚠️ Course content may be easily copied</li>
<li>⚠️ Website terms might not hold up legally</li>
</ul>

<h3>Close These Gaps Fast</h3>
<p><strong>Day 5 of the 7-Day Contract Assessment Challenge</strong> is specifically about building "copycat repellent" into your business:</p>

<ul>
<li>📋 IP protection clause templates</li>
<li>📝 Work-for-hire agreement language</li>
<li>🔒 Course and content protection strategies</li>
<li>⚖️ When and how to register trademarks/copyrights</li>
</ul>

<p><strong>Plus you''ll protect the other 6 areas most entrepreneurs miss.</strong></p>',
  'Protect your intellectual property:',
  'https://happyatlawnetwork.com/plans/1952315?bundle_token=797d0596dd239eeb6addca4b43dd3c7c&utm_source=quiz&utm_campaign=copycat_risk&utm_content=medium',
  'Start the $97 Challenge →'
);

-- Result 3: High Risk (0-29)
INSERT INTO results (id, quiz_id, uuid, title, slug, min_score, max_score, description, cta_text, cta_url, cta_button_text) VALUES (
  6, 2, UUID(),
  'High Copycat Risk',
  'high-risk',
  0, 29,
  '<h2>🚨 High Copycat Risk - Urgent Attention Needed</h2>
<p><strong>Your Risk Level: HIGH</strong></p>

<p>This is the honest truth: <strong>someone could legally copy your core business assets tomorrow</strong>, and you''d have very limited recourse.</p>

<h3>Your Current Exposure:</h3>
<ul>
<li>🚨 Your frameworks and methods aren''t legally protected</li>
<li>🚨 Course content could be copied and resold</li>
<li>🚨 Contractors may own content they created for you</li>
<li>🚨 Competitors could clone your signature offers</li>
</ul>

<h3>The Real Cost of Inaction</h3>
<p>Entrepreneurs lose an estimated <strong>$25,000+</strong> when their intellectual property is stolen. Beyond money, you lose:</p>
<ul>
<li>💔 Your unique market position</li>
<li>💔 Years of work building your methodology</li>
<li>💔 Trust from clients who see "copies" everywhere</li>
</ul>

<h3>The Fix is Simpler Than You Think</h3>
<p>The <strong>7-Day Contract Assessment Challenge</strong> includes everything you need to protect your intellectual property:</p>

<ul>
<li>📅 <strong>Day 5 (IP Protection):</strong> Build "copycat repellent" into every contract</li>
<li>📋 Templates for protecting courses, frameworks, and methods</li>
<li>🔒 Work-for-hire language so you own what contractors create</li>
<li>📝 Website terms that actually hold up legally</li>
</ul>

<p><strong>$97 could protect $25,000+ in intellectual property. This is urgent.</strong></p>',
  'Protect your business now:',
  'https://happyatlawnetwork.com/plans/1952315?bundle_token=797d0596dd239eeb6addca4b43dd3c7c&utm_source=quiz&utm_campaign=copycat_risk&utm_content=high',
  'Join the $97 Challenge Today →'
);

-- =============================================
-- TAGS FOR EMAIL SEGMENTATION
-- =============================================

INSERT INTO tags (id, name, slug, color, description) VALUES
(1, 'Foundation Score - Strong', 'foundation-strong', '#22c55e', 'Scored 80-100 on Foundation Score quiz'),
(2, 'Foundation Score - Growing', 'foundation-growing', '#eab308', 'Scored 50-79 on Foundation Score quiz'),
(3, 'Foundation Score - Building', 'foundation-building', '#ef4444', 'Scored 0-49 on Foundation Score quiz'),
(4, 'Copycat Risk - Low', 'copycat-low', '#22c55e', 'Low risk on Copycat quiz'),
(5, 'Copycat Risk - Medium', 'copycat-medium', '#eab308', 'Medium risk on Copycat quiz'),
(6, 'Copycat Risk - High', 'copycat-high', '#ef4444', 'High risk on Copycat quiz'),
(7, 'Quiz - Foundation Score', 'quiz-foundation', '#3b82f6', 'Took Foundation Score quiz'),
(8, 'Quiz - Copycat Risk', 'quiz-copycat', '#8b5cf6', 'Took Copycat Risk quiz');

-- =============================================
-- RESULT-TAG MAPPING
-- =============================================

CREATE TABLE IF NOT EXISTS result_tags (
  result_id INT NOT NULL,
  tag_id INT NOT NULL,
  PRIMARY KEY (result_id, tag_id)
);

INSERT INTO result_tags (result_id, tag_id) VALUES
(1, 1), (1, 7),  -- Strong Foundation + Quiz Foundation
(2, 2), (2, 7),  -- Growing Foundation + Quiz Foundation  
(3, 3), (3, 7),  -- Building Foundation + Quiz Foundation
(4, 4), (4, 8),  -- Low Risk + Quiz Copycat
(5, 5), (5, 8),  -- Medium Risk + Quiz Copycat
(6, 6), (6, 8);  -- High Risk + Quiz Copycat

-- =============================================
-- UPDATE QUIZ VIEW/COMPLETION COUNTERS
-- =============================================

UPDATE quizzes SET views = 0, completions = 0, conversion_rate = 0;

SELECT 'Quiz seed data loaded successfully!' as status;
SELECT q.title, q.slug, q.custom_domain, COUNT(qu.id) as questions 
FROM quizzes q 
LEFT JOIN questions qu ON qu.quiz_id = q.id 
GROUP BY q.id;
