/**
 * DOMAIN DETECTION MIDDLEWARE
 * Routes visitors to correct quiz based on domain
 */

const db = require('../utils/db');

async function domainDetect(req, res, next) {
  try {
    // Get the domain from request (strip www.)
    const host = req.hostname.replace(/^www\./, '').toLowerCase();
    
    // Check if this domain is linked to a quiz
    const [quizzes] = await db.query(
      'SELECT * FROM quizzes WHERE custom_domain = ? AND published = 1',
      [host]
    );
    
    if (quizzes.length > 0) {
      // Found a quiz for this domain
      req.quiz = quizzes[0];
      req.quizSlug = quizzes[0].slug;
      console.log(`Domain ${host} → Quiz: ${quizzes[0].title}`);
    } else {
      // No quiz found for this domain - use default or show error
      // Check if there's a default quiz
      const [defaultQuiz] = await db.query(
        'SELECT * FROM quizzes WHERE is_default = 1 AND published = 1 LIMIT 1'
      );
      
      if (defaultQuiz.length > 0) {
        req.quiz = defaultQuiz[0];
        req.quizSlug = defaultQuiz[0].slug;
      }
      // If no default, req.quiz will be undefined and routes can handle it
    }
    
    next();
  } catch (err) {
    console.error('Domain detection error:', err.message);
    next(); // Continue anyway, routes will handle missing quiz
  }
}

module.exports = domainDetect;
