# HAL Copycat Risk Factor Quiz

A custom quiz funnel for Happy At Law's Copycat Risk Factor assessment.

## Features

- **ScoreApp-Style Landing Page** - Two-column layout with lead capture
- **23 Quiz Questions** - Multiple choice with point-based scoring
- **3 Result Tiers** - Low (0-20), Medium (21-49), High (50+)
- **Auto-Tagging** - Mailchimp/Kit tags based on result
- **Email Integration** - Triggers result emails automatically
- **Full Analytics** - Track views, starts, completions
- **All Tracking Pixels** - GA4, Meta, TikTok, LinkedIn, etc.

## Scoring System

| Score Range | Result | Tag |
|-------------|--------|-----|
| 0-20 points | 🟢 LOW Risk | copycat-low-risk |
| 21-49 points | 🟡 MEDIUM Risk | copycat-medium-risk |
| 50+ points | 🔴 HIGH Risk | copycat-high-risk |

## Quick Setup

### 1. Database Setup

```bash
# Create database
mysql -u root -p -e "CREATE DATABASE hal_copycat_quiz CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"

# Import schema
mysql -u root -p hal_copycat_quiz < database.sql

# Import quiz data (questions, options, result pages)
mysql -u root -p hal_copycat_quiz < seed-quiz-data.sql
```

### 2. Configure Environment

```bash
cp .env.example .env
nano .env
```

Fill in:
- Database credentials
- Mailchimp API key + List ID
- SendGrid API key (for result emails)
- Tracking pixel IDs

### 3. Install & Run

```bash
npm install
npm start
```

### 4. Create Admin User

```bash
node setup.js
```

Visit: `http://yourdomain.com/admin`

## File Structure

```
├── server.js           # Express server
├── database.sql        # Schema
├── seed-quiz-data.sql  # Quiz content (questions, results)
├── .env.example        # Configuration template
├── routes/
│   ├── quiz.js         # Public quiz API
│   ├── admin.js        # Admin dashboard API
│   └── settings.js     # Settings API
├── services/
│   └── sync.js         # Email/webhook integrations
├── public_html/
│   ├── quiz/           # Quiz frontend
│   └── admin/          # Admin dashboard
└── uploads/            # User uploads
```

## Quiz Flow

1. **Landing Page** → Name + Email capture
2. **23 Questions** → Points accumulated per answer
3. **Score Calculation** → Sum of all points
4. **Result Page** → Based on score range
5. **Email Trigger** → Result-specific sequence starts

## Integration Setup

### Mailchimp

1. Get API key from Mailchimp → Account → API Keys
2. Get List/Audience ID from Audience → Settings → Audience ID
3. Add to `.env`:
   ```
   MAILCHIMP_API_KEY=xxxxxxxx-us21
   MAILCHIMP_LIST_ID=abc123def4
   ```

Tags applied automatically:
- `copycat-quiz-lead` (all quiz takers)
- `copycat-low-risk` / `copycat-medium-risk` / `copycat-high-risk` (based on result)

### SendGrid (Result Emails)

1. Get API key from SendGrid → Settings → API Keys
2. Add to `.env`:
   ```
   SENDGRID_API_KEY=SG.xxxxxxxx
   SENDGRID_FROM_EMAIL=angie@happyatlaw.com
   ```

### Tracking Pixels

Add any tracking IDs to `.env`:
```
GA4_MEASUREMENT_ID=G-XXXXXXXXXX
META_PIXEL_ID=1234567890
```

## Customization

### Edit Landing Page Design

Admin Dashboard → Quiz → Edit → Landing Page tab

Or directly in `seed-quiz-data.sql` under the `design` JSON field.

### Edit Questions

Admin Dashboard → Quiz → Edit → Questions tab

### Edit Result Pages

Admin Dashboard → Quiz → Edit → Results tab

### Change Colors

Primary (CTA buttons): `#FF6B8A` (HAL Pink)
Secondary (Hero bg): `#1E1B4B` (HAL Navy)

Set in quiz design JSON or admin settings.

## URLs

- **Quiz**: `https://yourdomain.com/quiz/copycat-risk-factor`
- **Admin**: `https://yourdomain.com/admin`
- **API**: `https://yourdomain.com/api/quiz/copycat-risk-factor`

## Support

Built by [Your Company] for Happy At Law LLC.

---

© 2026 Happy At Law LLC. All rights reserved.
