# EMAIL SEQUENCES FOR QUIZ FUNNELS
## Both Quizzes → $97 Contract Assessment Challenge

---

# QUIZ 1: FOUNDATION SCORE EMAILS

---

## STRONG FOUNDATION (Score 80-100)
### Tag: `foundation-strong`

---

### Email 1: Results + Validation (Immediate)
**Subject:** Your Foundation Score: {{score}}/100 - You're ahead of 85% of entrepreneurs

**Body:**
Hey {{first_name}},

You just got your Business Foundation Score: **{{score}} out of 100**.

That puts you in the **Strong Foundation** category—ahead of 85% of entrepreneurs when it comes to business protection.

You've clearly put work into your contracts, boundaries, and legal setup. That's not nothing. Most business owners are completely winging it.

But here's what I've learned after 26+ years of contract law:

**The entrepreneurs who think they're "all set" are often the ones blindsided by gaps they didn't know existed.**

Not because they're careless. Because the landscape keeps changing:
- AI compliance requirements that didn't exist 2 years ago
- Privacy laws evolving faster than most contracts
- Sophisticated IP theft that older protections don't cover

Your foundation is solid. The question is: is it current?

Tomorrow I'll share the #1 gap I see even in "protected" businesses.

Angie
Happy at Law

P.S. If you want to skip ahead and make sure your protection is fully up-to-date, the [7-Day Contract Assessment Challenge]({{challenge_url}}) is like a professional tune-up for $97.

---

### Email 2: The Hidden Gap (Day 2)
**Subject:** The gap that gets "protected" businesses

**Body:**
{{first_name}},

Yesterday I mentioned that even well-protected businesses have blind spots.

Here's the #1 I see:

**Scope creep that's been "normalized."**

You might have great contracts. Clear boundaries. Solid terms.

But somewhere along the way, you started letting small things slide:
- "Just one more revision" became three
- "Quick question" calls turned into 30-minute strategy sessions
- "Minor tweaks" ate hours you never billed

It's not in your contracts because it feels too small to address. But add it up over a year? 

Most entrepreneurs in your position are leaking $1,000-3,000/month they don't even notice.

Day 2 of the Contract Assessment Challenge specifically addresses this—including language that stops scope creep without making you feel like a jerk.

[Check out the Challenge here]({{challenge_url}})

More tomorrow,
Angie

---

### Email 3: What Changed in 2024 (Day 4)
**Subject:** Is your AI policy updated for 2024?

**Body:**
Quick question, {{first_name}}:

Do your contracts mention AI?

If they were written (or last updated) before 2023, probably not. And that's a problem because:

- **Zoom's AI transcription** might be capturing confidential client info
- **ChatGPT and similar tools** could be training on data you input
- **Your team or contractors** might be using AI in ways you haven't approved

I'm not anti-AI. I use it constantly. But your clients deserve to know how their information is being handled.

Day 4 of the Challenge covers exactly how to:
- Create an AI usage policy (takes 20 minutes)
- Add disclosure language to contracts
- Protect sensitive client data from AI training

Even strong foundations need updating. [The $97 Challenge makes it easy.]({{challenge_url}})

Angie

---

### Email 4: The Tune-Up Mindset (Day 6)
**Subject:** Why smart business owners get "tune-ups"

**Body:**
{{first_name}},

You wouldn't drive your car for 5 years without maintenance.

Your business protection works the same way.

Even if everything is solid, periodic check-ups catch:
- Outdated language that courts no longer enforce
- New requirements you didn't know existed
- Gaps that appeared as your business evolved

The 7-Day Contract Assessment Challenge is essentially a professional tune-up:

**7 days. 60-90 minutes each. $97 total.**

You'll either confirm everything's current (peace of mind) or catch gaps before they become expensive problems (prevention).

Either way, you win.

[Grab your spot here]({{challenge_url}})

Angie

---

### Email 5: Final Invitation (Day 8)
**Subject:** Last call: $97 protection tune-up

**Body:**
{{first_name}},

I'll keep this short.

Your Foundation Score showed you've built solid protection. That's genuinely impressive—most entrepreneurs haven't.

But solid ≠ current.
And current ≠ complete.

The 7-Day Contract Assessment Challenge ($97) will either:
1. Confirm you're fully protected → peace of mind
2. Reveal gaps to fix → prevent expensive problems

**7 days. 60-90 minutes each. Could save thousands.**

[Join here before the next cohort starts]({{challenge_url}})

Angie

P.S. This is my last email about the Challenge. If you're good, you're good. But if that little voice is saying "maybe I should check..."—trust it.

---
---

## GROWING FOUNDATION (Score 50-79)
### Tag: `foundation-growing`

---

### Email 1: Results + Reality Check (Immediate)
**Subject:** Your Foundation Score: {{score}}/100 - Here's what it means

**Body:**
Hey {{first_name}},

You just scored **{{score}} out of 100** on the Business Foundation Score.

That puts you in the **Growing Foundation** category.

Here's the honest translation:

You've started building protection—contracts exist, you understand the importance—but there are gaps. And those gaps have real costs:

- Scope creep might be draining $1,000-3,000/month
- One difficult client could create a $5,000+ problem
- Your IP might not be as protected as you think

The good news? **You're fixable.** And faster than you'd expect.

I've helped thousands of entrepreneurs go from "growing" to "strong" in as little as 7 days.

Tomorrow I'll break down exactly where your biggest risks probably are.

Angie
Happy at Law

P.S. If you want to fix everything this week, the [7-Day Contract Assessment Challenge]({{challenge_url}}) covers all 7 vulnerability areas for just $97.

---

### Email 2: Your Biggest Risk (Day 2)
**Subject:** Where you're probably losing money right now

**Body:**
{{first_name}},

Based on your Foundation Score, I'd bet money on this:

**You're working for free more than you realize.**

Not intentionally. But through scope creep that's become "normal":
- Sessions that run 15-20 minutes over
- "Quick" requests that take an hour
- Revisions that weren't in the original agreement

Most entrepreneurs in your score range are losing $1,500-3,000/month to this invisible drain.

Here's the thing: it's not a character flaw. It's a contract gap.

When your agreements don't have specific:
- Deliverables (exactly what's included)
- Boundaries (what's NOT included)
- Change order processes (how extras get handled)

...scope creep is inevitable.

Day 2 of the Contract Assessment Challenge gives you:
✅ Exact language to stop scope creep
✅ Templates for change orders
✅ Scripts for saying "no" without burning bridges

[It's $97 for all 7 days]({{challenge_url}}). Day 2 alone could pay for it 10x over.

More tomorrow,
Angie

---

### Email 3: The Client Time Bomb (Day 4)
**Subject:** How to spot a problem client BEFORE they become your problem

**Body:**
{{first_name}},

Here's something your Foundation Score probably revealed:

You don't have a system for identifying difficult clients before they sign.

Most entrepreneurs learn the red flags after they've been burned:
- The client who always "has one more thing"
- The one who disputes invoices
- The one who demands refunds for finished work

But these clients almost always show warning signs in the first conversation.

Day 1 of the Contract Assessment Challenge teaches you:
- The 5 red flags that predict problem clients
- What to include in contracts to protect yourself
- How to "fire" clients gracefully when needed

Because the best way to handle difficult clients? **Don't take them in the first place.**

[Join the Challenge here]({{challenge_url}}) - $97 for 7 days of protection

Angie

---

### Email 4: What Happens When Things Go Wrong (Day 6)
**Subject:** What would you do if you couldn't work for 2 weeks?

**Body:**
{{first_name}},

Quick scenario:

You get sick. Or a family emergency hits. Or your power goes out for a week.

What happens to your clients? Your deliverables? Your income?

If your answer is "chaos" or "I'd have to give refunds," your contracts need work.

**Force majeure clauses** (fancy legal term for "stuff happens") protect you when life gets in the way. They:
- Define what counts as an emergency
- Specify what happens to deadlines
- Protect you from being sued for non-delivery

Day 3 of the Challenge walks you through exactly how to add this protection to every contract.

Because emergencies don't announce themselves. Protection needs to be in place BEFORE you need it.

[Get protected with the $97 Challenge]({{challenge_url}})

Angie

---

### Email 5: Decision Time (Day 8)
**Subject:** Your foundation is growing. Want to make it strong?

**Body:**
{{first_name}},

Over the past week, I've shown you where your Growing Foundation has gaps:
- Scope creep draining income
- Problem clients slipping through
- No protection when emergencies hit

Here's the thing about gaps: **they don't fix themselves.**

Every week you wait:
- Another few hundred dollars leaks to scope creep
- Another potential problem client might sign
- Another day without emergency protection

The 7-Day Contract Assessment Challenge fixes ALL of this:

**$97. 7 days. 60-90 minutes each. All 7 vulnerability areas covered.**

[This is the link]({{challenge_url}})

You already know you need better protection. The question is: this week or later?

I vote this week.

Angie

---
---

## BUILDING FOUNDATION (Score 0-49)
### Tag: `foundation-building`

---

### Email 1: Results + Compassion (Immediate)
**Subject:** Your Foundation Score: {{score}}/100 - Let's talk

**Body:**
Hey {{first_name}},

I'm going to be straight with you.

Your Business Foundation Score—**{{score}} out of 100**—puts you in the Building Foundation category.

Translation: your business is more exposed than it should be.

But before you spiral, let me tell you something:

**You're not alone. And this is fixable.**

Most entrepreneurs start exactly where you are. They're so busy building the business that protection falls to the bottom of the list.

The problem is, problems don't wait until you're ready:
- Scope creep starts costing you $3,000+/month
- One difficult client demands a $5,000+ refund
- Your ideas get copied with no legal recourse

I don't say this to scare you. I say it because **now you know**. And knowing means you can fix it.

Tomorrow, I'll show you the fastest path forward.

Angie
Happy at Law

P.S. If you want to start fixing this today, the [7-Day Contract Assessment Challenge]({{challenge_url}}) covers everything for $97. Just 60-90 minutes a day.

---

### Email 2: The Real Cost (Day 2)
**Subject:** How much are weak contracts actually costing you?

**Body:**
{{first_name}},

Let's do some quick math on what your current protection gaps might be costing:

**Scope creep:** $2,000-4,000/month
(Those "just one more things" add up fast)

**Difficult client disputes:** $5,000-10,000/year
(Refunds, lost time, stress)

**No emergency protection:** $10,000-15,000 risk
(One illness or crisis could derail everything)

**Unprotected IP:** $25,000+ risk
(Your frameworks, courses, methods—anyone could copy them)

Total annual exposure: **$50,000+**

I'm not trying to scare you. I'm trying to show you why $97 for the Contract Assessment Challenge is a no-brainer.

**7 days of focused work could protect $50,000+ in annual risk.**

[Here's the link]({{challenge_url}})

Angie

---

### Email 3: The "I'll Do It Later" Problem (Day 4)
**Subject:** Why "later" usually means "never" (and what to do about it)

**Body:**
{{first_name}},

Can I be honest about something?

Most entrepreneurs who score in the Building Foundation range never fix their protection.

Not because they're dumb or lazy. Because:
- It feels overwhelming (where do I even start?)
- It feels expensive (lawyers cost hundreds per hour)
- It feels boring (contracts aren't exactly exciting)
- There's always something more urgent

Then one day, something goes wrong. And suddenly "later" becomes "too late."

That's exactly why I created the 7-Day Contract Assessment Challenge:

**Not overwhelming:** One focused topic per day, 60-90 minutes
**Not expensive:** $97 total (not $500/hour lawyer fees)
**Not boring:** Practical, immediately usable, action-focused
**Urgent:** Because it IS urgent—you just don't feel it yet

You have two choices:
1. Fix this now, on your terms, for $97
2. Fix this later, in crisis mode, for thousands

[Choose option 1]({{challenge_url}})

Angie

---

### Email 4: What 7 Days Could Change (Day 6)
**Subject:** Where you could be in 7 days

**Body:**
{{first_name}},

Picture this:

One week from today, you wake up with:
✅ Contracts that actually protect you
✅ Clear boundaries clients respect
✅ Scope creep eliminated
✅ Problem client red flags memorized
✅ Emergency protection in place
✅ IP legally protected
✅ Personal assets separated from business risk

All of that. 7 days. 60-90 minutes per day.

That's the Contract Assessment Challenge.

**Day 1:** Cranky client protection
**Day 2:** Scope creep elimination
**Day 3:** Emergency/force majeure coverage
**Day 4:** AI and data policies
**Day 5:** IP "copycat repellent"
**Day 6:** Personal/business separation
**Day 7:** Confidentiality systems

By Day 8, you're protected. Actually protected.

[It's $97. Here's the link.]({{challenge_url}})

Angie

---

### Email 5: Last Chance (Day 8)
**Subject:** This is my last email (decision time)

**Body:**
{{first_name}},

This is my last email about the Contract Assessment Challenge.

Here's where we are:

Your Foundation Score revealed real gaps. Not "maybe someday" problems—active exposure that's probably already costing you money.

You have two options:

**Option 1:** Continue as-is
- Keep losing money to scope creep
- Hope difficult clients don't find the loopholes
- Cross fingers that no emergencies hit
- Risk someone copying your entire business

**Option 2:** Fix it this week for $97
- 7 days, 60-90 minutes each
- All 7 vulnerability areas covered
- Templates, action plans, real protection
- [Click here to join]({{challenge_url}})

I can't make this decision for you. But I can tell you: the entrepreneurs who fix their protection sleep better. Work better. Earn more.

Your call.

Angie

P.S. Every week you wait probably costs more than $97. Just saying.

---
---

# QUIZ 2: COPYCAT RISK EMAILS

---

## LOW COPYCAT RISK (Score 60-80)
### Tag: `copycat-low`

---

### Email 1: Results + Validation (Immediate)
**Subject:** Your Copycat Risk Level: LOW - Your IP is well protected

**Body:**
Hey {{first_name}},

Great news: your Copycat Risk assessment came back **LOW**.

That means your intellectual property—your frameworks, courses, content, and methods—has real legal protection.

You've done what most entrepreneurs haven't:
✅ Proper registrations (trademarks, copyrights)
✅ Contracts that protect your IP
✅ Clear ownership of created content

This puts you ahead of 73% of online entrepreneurs who have zero formal IP protection.

But here's the thing about IP protection: **it's not static.**

As you create new content, hire new contractors, and expand your business, new vulnerabilities can appear. Protection that worked for Version 1.0 might have gaps for Version 3.0.

Tomorrow I'll share what to watch for as you grow.

Angie
Happy at Law

P.S. The [7-Day Contract Assessment Challenge]({{challenge_url}}) includes advanced IP protection strategies (Day 5) plus protection for the other 6 areas most entrepreneurs miss. $97 for all 7 days.

---

### Email 2: Growing Pains (Day 2)
**Subject:** As you scale, your IP risks change

**Body:**
{{first_name}},

Your IP protection is solid. But here's what I see with entrepreneurs at your level:

**Growth creates new exposure.**

When you:
- Hire contractors to create content → Who owns what?
- Launch new courses or programs → Are terms updated?
- Bring on team members → Do NDAs cover everything?
- Collaborate with others → Is IP division clear?

Each expansion can create gaps in protection that didn't exist before.

Day 5 of the Contract Assessment Challenge covers exactly this—advanced IP protection for growing businesses:

- Work-for-hire language that's bulletproof
- Collaboration agreements that protect your share
- Course protection that survives student access
- Content licensing that maintains your ownership

[The Challenge is $97 for all 7 days]({{challenge_url}}). Day 5 alone is worth that if you're scaling.

Angie

---

### Email 3: The Other 6 Risks (Day 4)
**Subject:** Your IP is protected. What about these 6 areas?

**Body:**
{{first_name}},

You scored LOW on Copycat Risk. Your intellectual property is well protected.

But IP is just 1 of 7 critical protection areas. How are you doing on:

1. **Client red flags** - Can you spot problem clients before signing?
2. **Scope creep** - Are you getting paid for all your work?
3. **Emergencies** - What happens if you can't deliver?
4. **AI compliance** - Are your data practices current?
5. ~~IP protection~~ ✅ You're covered
6. **Asset separation** - Is your personal stuff protected?
7. **Confidentiality** - Are client secrets truly secure?

The 7-Day Contract Assessment Challenge covers ALL of these.

Your IP protection proves you take business seriously. Make sure the other 6 areas match.

[$97 for 7 days of complete protection]({{challenge_url}})

Angie

---

### Email 4: Final Invitation (Day 6)
**Subject:** Complete protection = peace of mind

**Body:**
{{first_name}},

Quick gut check:

You know your IP is protected. But when you think about the other areas of your business—client contracts, scope boundaries, emergency coverage—do you feel the same confidence?

If there's any hesitation, the 7-Day Contract Assessment Challenge is for you:

**$97. 7 days. 60-90 minutes each. All 7 vulnerability areas.**

You've already proven you invest in protection. This just completes the picture.

[Join here]({{challenge_url}})

Angie

---
---

## MEDIUM COPYCAT RISK (Score 30-59)
### Tag: `copycat-medium`

---

### Email 1: Results + Reality (Immediate)
**Subject:** Your Copycat Risk Level: MEDIUM - Gaps exist

**Body:**
Hey {{first_name}},

Your Copycat Risk assessment came back **MEDIUM**.

Here's what that means:

You have some IP protection in place—more than many entrepreneurs. But there are gaps that leave your intellectual property vulnerable.

A savvy competitor (or a disgruntled student, or a contractor who leaves) could potentially:
- Copy your framework with limited consequences
- Claim ownership of content they helped create
- Take your methods and launch a competing offer

I don't say this to scare you. I say it because **these gaps are fixable**, and most entrepreneurs don't realize they exist until something goes wrong.

Tomorrow I'll break down exactly where your biggest IP risks probably are.

Angie
Happy at Law

P.S. Day 5 of the [7-Day Contract Assessment Challenge]({{challenge_url}}) is specifically about building "copycat repellent." $97 for all 7 days.

---

### Email 2: Who Actually Owns Your Content? (Day 2)
**Subject:** The contractor ownership trap

**Body:**
{{first_name}},

Quick question:

That contractor who helped you build your course? The designer who created your workbooks? The VA who writes your social posts?

**Who legally owns what they created?**

If you don't have explicit work-for-hire agreements, the answer might surprise you: **they do.**

Without proper language, contractors maintain ownership of their work—even if you paid for it.

This means:
- They could use those designs for other clients
- Course content might not fully belong to you
- Your "signature" materials might be legally theirs

Day 5 of the Contract Assessment Challenge includes:
✅ Work-for-hire templates
✅ IP assignment agreements
✅ Language that makes ownership crystal clear

[Protect your content for $97]({{challenge_url}})

Angie

---

### Email 3: Course Content Protection (Day 4)
**Subject:** What stops your students from stealing your course?

**Body:**
{{first_name}},

You sell courses or programs. Great.

What legally stops a student from:
- Downloading everything and sharing it?
- Using your framework to teach others?
- Basically cloning your course and competing with you?

If your answer is "I'm not sure," your terms need work.

**Day 5 of the Challenge covers:**
- Course terms that actually protect your content
- What to do when someone violates them
- How to structure programs so IP stays protected
- Licensing language that maintains your ownership

Your courses are worth thousands of hours of work. Protection should be comprehensive.

[$97 for 7 days of business protection]({{challenge_url}})

Angie

---

### Email 4: The Full Picture (Day 6)
**Subject:** IP is just one piece of the puzzle

**Body:**
{{first_name}},

Your Copycat Risk assessment revealed gaps in IP protection.

But here's the thing: IP is just Day 5 of a 7-day Challenge that covers:

**Day 1:** Spot cranky clients before they cost you
**Day 2:** Stop working for free (scope creep)
**Day 3:** Protect against emergencies
**Day 4:** AI and data compliance
**Day 5:** IP "copycat repellent" ← Your main gap
**Day 6:** Separate personal and business assets
**Day 7:** Lock down confidentiality

**$97 total. 60-90 minutes per day. All 7 areas covered.**

You'll walk away with your IP protected PLUS six other critical areas.

[Start protecting everything]({{challenge_url}})

Angie

---

### Email 5: Decision Time (Day 8)
**Subject:** Protect your IP or risk losing it

**Body:**
{{first_name}},

I'll be direct:

Your intellectual property has medium protection with real gaps.

Every week those gaps exist:
- A competitor could be studying your methods
- A contractor might not realize you own their work
- A student could be sharing your course

The [7-Day Contract Assessment Challenge]({{challenge_url}}) fixes ALL of this:

**Day 5 specifically builds "copycat repellent" into every contract and agreement.**

$97. One week. Then you're protected.

Your IP represents years of work. Protect it.

Angie

---
---

## HIGH COPYCAT RISK (Score 0-29)
### Tag: `copycat-high`

---

### Email 1: Results + Urgency (Immediate)
**Subject:** Your Copycat Risk Level: HIGH - Urgent action needed

**Body:**
{{first_name}},

I need to be honest with you.

Your Copycat Risk assessment came back **HIGH**.

What that means: someone could legally copy your core business—your frameworks, courses, methods, and content—tomorrow, and you'd have very limited recourse.

This isn't fear-mongering. This is fact:
- Without proper registrations, your IP has minimal legal protection
- Without contract language, clients can use your methods however they want
- Without work-for-hire agreements, contractors may own what they created

I know this is hard to hear. But **you needed to know**, and now you can fix it.

Tomorrow I'll show you exactly what's at stake and the fastest path to protection.

Angie
Happy at Law

P.S. This is urgent. The [7-Day Contract Assessment Challenge]({{challenge_url}}) includes everything you need to protect your IP. $97 for all 7 days. Consider starting today.

---

### Email 2: What You Could Lose (Day 2)
**Subject:** The real cost of unprotected IP

**Body:**
{{first_name}},

Let's talk about what's actually at risk:

**Your signature framework:** The thing you're known for. The method that makes you unique. Right now, anyone could copy it.

**Your courses/programs:** Hundreds of hours of work. Currently, students could share or replicate them with limited consequences.

**Your content:** Blog posts, lead magnets, videos. Without proper terms, they're essentially public domain.

**Your brand identity:** The positioning you've built. Competitors could clone it.

Add it up, and we're talking about **$25,000-$100,000+ of intellectual property** that isn't protected.

One successful copycat could:
- Dilute your market position
- Confuse your audience
- Compete against you with YOUR ideas

Day 5 of the Contract Assessment Challenge is specifically designed to fix this:
- IP protection clauses for every contract
- Terms that actually hold up legally
- Work-for-hire language that protects everything

[It's $97. This is urgent.]({{challenge_url}})

Angie

---

### Email 3: Why This Happens (Day 4)
**Subject:** You're not alone (and this is fixable)

**Body:**
{{first_name}},

I want to say something important:

A high Copycat Risk score doesn't mean you did something wrong. It means you've been focused on building your business, not the legal details.

That's normal. It's actually how most entrepreneurs operate.

The problem is, IP protection isn't like a leaky faucet—it doesn't drip loudly until you fix it. It's silent. Until one day:

- A competitor launches "your" program
- A contractor takes "your" content to another client
- A student copies "your" course

Then it's loud. And expensive. And heartbreaking.

The good news: **this is completely fixable in 7 days.**

Day 5 of the Contract Assessment Challenge gives you everything:
- Templates that protect your IP immediately
- Language for every contract type
- Systems to protect future content automatically

[$97 for protection that could save $25,000+]({{challenge_url}})

Angie

---

### Email 4: Protection in 7 Days (Day 6)
**Subject:** What "protected" looks like in one week

**Body:**
{{first_name}},

Imagine this:

7 days from now, you have:
✅ IP clauses in every client contract
✅ Course terms that prevent copying
✅ Work-for-hire agreements for all contractors
✅ Website terms that protect your content
✅ Clear ownership of everything you've created

That's what the Contract Assessment Challenge delivers.

**Day 5 is specifically about IP protection:**
- Build "copycat repellent" into everything
- Templates you can use immediately
- Step-by-step action plan

**Plus Days 1-4 and 6-7 protect everything else:**
- Difficult clients
- Scope creep
- Emergencies
- AI compliance
- Asset protection
- Confidentiality

**$97. 7 days. Complete protection.**

[Start today]({{challenge_url}})

Angie

---

### Email 5: Final Warning (Day 8)
**Subject:** Last email: Your IP is exposed

**Body:**
{{first_name}},

This is my last email about the Contract Assessment Challenge.

Here's the situation:

Your Copycat Risk score revealed that your intellectual property—your life's work—isn't protected.

Every day this continues:
- Someone could copy your framework
- Contractors might own content you paid for
- Students could redistribute your courses
- Competitors could clone your positioning

**One successful copycat could cost you $25,000-$100,000+**

The fix: [7-Day Contract Assessment Challenge]({{challenge_url}})

**$97. 7 days. 60-90 minutes each.**

Day 5 specifically builds IP protection into every contract and agreement.

I can't make you do this. But I can tell you: this is urgent. And it's fixable. And $97 is nothing compared to what you could lose.

Your choice.

Angie

P.S. After 26+ years of fixing contract disasters, I can tell you: the entrepreneurs who wish they'd acted sooner always outnumber the ones who wish they'd waited.

---
---

# TAGGING SUMMARY FOR KIT

| Quiz | Result | Tag to Apply |
|------|--------|--------------|
| Foundation Score | Strong (80-100) | `foundation-strong`, `quiz-foundation` |
| Foundation Score | Growing (50-79) | `foundation-growing`, `quiz-foundation` |
| Foundation Score | Building (0-49) | `foundation-building`, `quiz-foundation` |
| Copycat Risk | Low (60-80) | `copycat-low`, `quiz-copycat` |
| Copycat Risk | Medium (30-59) | `copycat-medium`, `quiz-copycat` |
| Copycat Risk | High (0-29) | `copycat-high`, `quiz-copycat` |

---

# AUTOMATION TRIGGERS

**Foundation Score Quiz:**
- On completion → Add tag based on result
- Trigger 5-email sequence for that tag
- Wait 2 weeks → If no purchase → Add to general newsletter

**Copycat Risk Quiz:**
- On completion → Add tag based on result  
- Trigger 5-email sequence for that tag
- Wait 2 weeks → If no purchase → Add to general newsletter

**Cross-Quiz Logic:**
- If someone takes BOTH quizzes → Priority to most recent
- Don't send duplicate "Day 2" emails if they overlap

---

# TIMING

| Email | Send Time |
|-------|-----------|
| Email 1 | Immediately after quiz |
| Email 2 | Day 2, 10am |
| Email 3 | Day 4, 10am |
| Email 4 | Day 6, 10am |
| Email 5 | Day 8, 10am |
